---
name: openspec-new-change
description: Start a new OpenSpec change using the experimental artifact workflow. Use when the user wants to create a new feature, fix, or modification with a structured step-by-step approach.
license: MIT
compatibility: Requires openspec CLI.
metadata:
  author: openspec
  version: "1.0"
  generatedBy: "1.0.1"
---

Start a new change using the experimental artifact-driven approach.

**Input**: The user's request should include a change name (kebab-case) OR a description of what they want to build.

**Steps**

1. **If no clear input provided, ask what they want to build**

   Use the **AskUserQuestion tool** (open-ended, no preset options) to ask:
   > "What change do you want to work on? Describe what you want to build or fix."

   From their description, derive a kebab-case name (e.g., "add user authentication" → `add-user-auth`).

   **IMPORTANT**: Do NOT proceed without understanding what the user wants to build.

2. **Determine the workflow schema**

   Use the default schema (omit `--schema`) unless the user explicitly requests a different workflow.

   **Use a different schema only if the user mentions:**
   - A specific schema name → use `--schema <name>`
   - "show workflows" or "what workflows" → run `openspec schemas --json` and let them choose

   **Otherwise**: Omit `--schema` to use the default.

3. **Create the change directory**
   ```bash
   openspec new change "<name>"
   ```
   Add `--schema <name>` only if the user requested a specific workflow.
   This creates a scaffolded change at `openspec/changes/<name>/` with the selected schema.

4. **Show the artifact status**
   ```bash
   openspec status --change "<name>"
   ```
   This shows which artifacts need to be created and which are ready (dependencies satisfied).

5. **Get instructions for the first artifact**
   The first artifact depends on the schema (e.g., `proposal` for spec-driven).
   Check the status output to find the first artifact with status "ready".
   ```bash
   openspec instructions <first-artifact-id> --change "<name>"
   ```
   This outputs the template and context for creating the first artifact.

6. **STOP and wait for user direction**

**Oinone Framework Integration**

When creating artifacts for this project, you MUST consider Oinone framework implementation patterns:

- **For `design.md`**: Include Oinone-specific technical decisions:
  - Model/Enum definitions with `@Model` and `@Field.*` annotations
  - Service interfaces with `@Fun` and `@Function` annotations
  - Pops query patterns using `LambdaQueryWrapper`
  - DEV-1/DEV-2 phase separation
  - Package structure: `...api.model.{biz}` and `...core.service.{biz}`

- **For `tasks.md`**: Break down tasks following Oinone development phases:
  - DEV-1: Enum, Model, Menu definitions
  - DEV-2: Service and Controller/Action implementations

**【强制】规则 7：设计阶段必须扫描 Oinone 文档**
在 `design.md` 中涉及以下功能时，必须先扫描 `.trae/source/oinone-docs/` 目录下的文档，确定 Oinone 是否支持：
- 权限（RBAC、数据权限、行权限）→ 参考 `security-in-oinone.md`
- 工作流（审批流程）→ 参考 `workflow.md` 和 `process-configuration-workflow-integration-and-triggering.md`
- 文件导入导出 → 参考 `export-and-import.md` 和 `import-export.md`
- 消息中心（预警、待办）→ 参考 `message-hub-API.md`
- 业务审计 → 参考 `business-audit.md`
- 国际化 → 参考 `translation.md`
- 公式计算 → 参考 `expressions-guide.md`

**【强制】规则 8：Service/Action 方法必须判断 Oinone 支持**
在 `design.md` 中定义每个 Service/Action 方法时，必须包含以下信息：
```
- `methodName(params)` - 方法描述
  - **Oinone 默认数据管理器支持**：✅ 支持 / ❌ 不支持
  - **原因**：说明为何支持或不支持
  - **参考文档**：[文档名称](.trae/source/oinone-docs/...) （如果支持）
  - **实现方式**：说明如何使用 Oinone 能力或自行开发
  - **可直接勾选完成**：✅ 是 / ❌ 否 （如果支持）
```

**【强制】** Reference Oinone official documentation:
- `.trae/source/oinone-docs/zh-cn/DevManual/Reference/Back-EndFramework/ORM-API.md` - Model, Field, Pops, Service definitions
- `.trae/source/oinone-docs/zh-cn/DevManual/Reference/Back-EndFramework/UX-API.md` - Menu, View, Widget definitions
- `.trae/source/oinone-docs/zh-cn/DevManual/Reference/Back-EndFramework/security-in-oinone.md` - Security, RBAC
data permissions
- `.trae/source/oinone-docs/zh-cn/DevManual/CommonSolutions/Back-End/process-configuration-workflow-integration-and-triggering.md` - Workflow
- `.trae/source/oinone-docs/zh-cn/DevManual/Tutorials/export-and-import.md` - Import/Export
- `.trae/source/oinone-docs/zh-cn/DevManual/Reference/Back-EndFramework/AdvanceAPI/message-hub-API.md` - Message Hub
- `.trae/rules/project_rules.md` - Project-specific Oinone development guidelines
**【强制】** When uncertain about Oinone patterns, ALWAYS consult official documentation first.

**Output**

After completing the steps, summarize:
- Change name and location
- Schema/workflow being used and its artifact sequence
- Current status (0/N artifacts complete)
- The template for the first artifact
- Note: "This project uses Oinone framework - artifacts will follow Oinone patterns (see .trae/source/oinone-docs/ and project_rules.md)"
- Prompt: "Ready to create the first artifact? Just describe what this change is about and I'll draft it, or ask me to continue."

**Guardrails**
- Do NOT create any artifacts yet - just show the instructions
- Do NOT advance beyond showing the first artifact template
- If the name is invalid (not kebab-case), ask for a valid name
- If a change with that name already exists, suggest continuing that change instead
- Pass --schema if using a non-default workflow
