# Oinone 后端开发规范

> **版本**: 3.2 | **基准**: Oinone 官方文档 | **强制**: 参考 `.trae/source/oinone-docs/` 官文文档

## 1. 项目结构
禁止新增一级目录或 Maven 模块，只能在现有模块下新建子目录。必须与用户二次确认。

## 2. DEV 阶段
**DEV-1**: Enum、Model、Menu。**DEV-2**: Service、Action。DEV-1 未完成不得进入 DEV-2。DEV-1 严禁实现 Service/Action，DEV-2 严禁修改 Enum/Model/Menu。

## 3. Oinone 框架
**Model**: `@Model` 标记，`@Field.*` 定义字段，`@Field.many2one`/`@Field.one2many`/`@Field.many2many` 定义关联。继承 `IdModel`/`CodeModel`/`VersionModel`。禁止手动 getter/setter。many2one 关联字段的 relationFields 必须在模型中显式定义，并设置 invisible=true。

**Field**: String→`@Field.String`，Long/Integer→`@Field.Integer`，Boolean→`@Field.Boolean`，Date→`@Field.Date`，Enum→`@Field.Enum`，BigDecimal→`@Field.Money`/`@Field.Float`。禁止 `@Field.Long`/`@Field.Integer`/`@Field.Decimal`。

**Service**: 接口 `@Fun`，方法 `@Function`，事务 `@PamirsTransactional`。接口放 `...api.api.{biz}`，实现放 `...core.service.{biz}`。

**Pops**: 简单查询 `new Model().setId(id).queryById()`，复杂查询 `Pops.<Model>lambdaQuery().eq(Model::getField, value).list()`。禁止手写 SQL。

**UX**: 菜单 `@UxMenus`/`@UxMenu`。参考 UX-API.md。

**Action**: 只承担协调者角色，不直接用 Pops 或操作事务。

## 4. 命名与包
类名 `UpperCamelCase`，方法名 `lowerCamelCase`，常量全大写下划线。禁止拼音英文混合。服务接口 `{Entity}Service`，实现 `{Entity}ServiceImpl`。Model/Enum: `...api.model.{biz}`，Service 接口: `...api.api.{biz}`，Service 实现: `...core.service.{biz}`。

## 5. 集合与异常
`RuntimeException` 不应 `catch`。异常不做流程控制。统一用 `PamirsException`。

## 6. 数据库与分层
依赖方向：Action → Service → Model/Pops。

## 7. Oinone 能力（设计阶段）
**【强制】** 设计阶段发现权限功能时，先扫描 Oinone 文档确定是否支持。
**【强制】** 设计阶段发现业务审计、数据BI、系统集成、API开放、国际化、工作流、文件导入导出等功能时，不需要设计，直接用Oinone默认提供能力就行。
## 8. Service/Action 通用规则
**【强制】** 设计阶段：定义 Service/Action 方法时，先判断 Oinone 默认数据管理器是否支持。若支持则贴参考链接、说明方法定义和实现方式，可直接勾选完成；若不支持则自行开发，并在 `design.md` 中说明方法定义、实现方式、默认能力为何满足不了。开发阶段：按照设计阶段的决策执行，任务项保留不删。

## 9. OpenSpec 工作流
工件：`proposal.md`（WHY）、`specs/`（WHEN/THEN/AND）、`design.md`（HOW）、`tasks.md`（任务清单）。design.md 包含 Oinone 技术决策、DEV-1/DEV-2 划分、字段类型映射、查询方案、扩展点、错误处理。tasks 遵循 DEV-1/DEV-2 划分，每个任务引用 Oinone 模式。

## 10. 自我检查
完成开发后必须检查：无编译错误、无语法错误、无未使用导入、无循环依赖。字段类型正确使用 `@Field.*`。关联关系配置完整（many2one/one2many/many2many + invisible=true）。Service 使用 `@Fun`/`@Function`/`@PamirsTransactional`。查询使用 Pops 或 LambdaQuery。

## 11. 官方文档参考
ORM-API.md（Model、Field、Pops、Service）、UX-API.md（Menu、View、Widget）、model.md（模型设计）。
