# Oinone 菜单配置规则

Oinone 框架中 `@UxMenu` 注解的定义如下：

```java
public @interface UxMenu {
    String name() default "";
    @AliasFor("label")
    String value() default "";
    @AliasFor("value")
    String label() default "";
    String summary() default "";
    String icon() default "";
    ClientTypeEnum[] clientTypes() default {ClientTypeEnum.PC, ClientTypeEnum.MOBILE, ClientTypeEnum.PAD};
}
```

## 1. 菜单优先级设置

### 错误方式（禁止）
```java
@UxMenus
public class LeadMenus {
    @UxMenu(value = "线索管理", priority = 1)  // ❌ priority 属性不存在
    class LeadMenu { }
}
```

### 正确方式
```java
@UxMenus(basePriority = 1)
public class LeadMenus {
    @UxMenu(value = "线索管理", icon = "oinone-message")
    class LeadMenu { }
}
```

**说明**：
- 使用 `@UxMenus(basePriority = ...)` 设置菜单集合的起始优先级
- 系统会根据 `basePriority` 值按从小到大的顺序显示菜单
- 同一个 `@UxMenus` 类中的多个菜单会按照代码中的声明顺序依次排列

## 2. 菜单图标配置

### 格式
```java
@UxMenu(value = "菜单名称", icon = "图标名称")
```

### 图标来源
- 图标从 Oinone 官方图标库中选择
- 图标库路径：`.trae/res/icon.md`
- 选择最匹配功能语义的图标

### 常用图标参考
| 功能类型 | 推荐图标 |
|----------|----------|
| 线索/消息 | `oinone-message` |
| 客户/公司 | `oinone-gongsi` |
| 联系人/用户 | `oinone-yonghu1` |
| 机会/重要 | `oinone-xingxing` |
| 任务/待办 | `oinone-daiban` |
| 记录/沟通 | `oinone-msg` |
| 产品 | `oinone-chanpinshili` |
| 报价/单据 | `oinone-baoxiao` |
| 合同/文档 | `oinone-file-text-outlined` |
| 活动/推广 | `oinone-huojian` |
| 工单/审核 | `oinone-daishenhe` |
| 报表/统计 | `oinone-baobiao` |

## 3. CRM 业务菜单优先级参考

根据 PRD 业务流程（线索→客户→机会→报价→合同→回款）设置菜单优先级：

| 优先级 | 菜单名称 | 图标 | 业务流程阶段 |
|--------|----------|-------|--------------|
| 1 | 线索管理 | `oinone-message` | 线索进入 |
| 2 | 客户管理 | `oinone-gongsi` | 客户转化 |
| 3 | 联系人管理 | `oinone-yonghu1` | 客户联系人 |
| 4 | 销售机会 | `oinone-xingxing` | 机会推进 |
| 5 | 任务管理 | `oinone-daiban` | 跟进任务 |
| 6 | 跟进记录 | `oinone-msg` | 跟进历史 |
| 7 | 产品中心 | `oinone-chanpinshili` | 报价基础 |
| 8 | 报价管理 | `oinone-baoxiao` | 机会报价 |
| 9 | 合同管理 | `oinone-file-text-outlined` | 成交合同 |
| 10 | 营销活动 | `oinone-huojian` | 线索来源 |
| 11 | 工单管理 | `oinone-daishenhe` | 售后服务 |
| 12 | 经营报表 | `oinone-baobiao` | 数据分析 |

## 4. 完整示例

```java
@UxMenus(basePriority = 1)
public class LeadMenus {

    @UxMenu(value = "线索管理", icon = "oinone-message")
    class LeadMenu {
        @UxMenu("线索列表")
        @UxRoute(model = Lead.MODEL_MODEL)
        class LeadListMenu {
        }
    }
}

@UxMenus(basePriority = 2)
public class CustomerMenus {

    @UxMenu(value = "客户管理", icon = "oinone-gongsi")
    class CustomerMenu {
        @UxMenu("客户列表")
        @UxRoute(model = Customer.MODEL_MODEL)
        class CustomerListMenu {
        }
    }

    @UxMenu(value = "联系人管理", icon = "oinone-yonghu1")
    class ContactMenu {
        @UxMenu("联系人列表")
        @UxRoute(model = Contact.MODEL_MODEL)
        class ContactListMenu {
        }
    }
}
```

## 5. 注意事项

1. **禁止使用 `priority` 属性**：`@UxMenu` 注解没有 `priority` 属性，使用 `@UxMenus(basePriority = ...)` 代替
2. **图标必须存在**：确保图标名称在 `.trae/res/icon.md` 中存在
3. **优先级递增**：`basePriority` 值应该按业务流程顺序递增
4. **子菜单顺序**：同一个类中的多个子菜单按代码声明顺序排列
